/* --------------------------------------------------------------
  PreviewType.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

/**
 * Class PreviewType
 */
export default class PreviewType {
	/**
	 * Class Constructor
	 */
	constructor() {
		/**
		 * Preview type HTML class.
		 *
		 * @type {String}
		 */
		this.class = null;
		
		/**
		 * Preview type display name.
		 *
		 * @type {String}
		 */
		this.name = null;
		
		/**
		 * CSS Styling set with jQuery
		 *
		 * @type {Object}
		 */
		this.previewCss = null;
		
		/**
		 * Font-Awesome Icon Class
		 *
		 * @type {String}
		 */
		this.iconClass = null;
		
		/**
		 * Resolution
		 *
		 * @type {String}
		 */
		this.resolution = null;
	}
	
	/**
	 * Class Getter
	 *
	 * @return {String}
	 */
	getClass() {
		return this.class;
	}
	
	/**
	 * Class Setter
	 *
	 * @param {String} className
	 *
	 * @return {PreviewType}
	 */
	setClass(className) {
		StyleEdit.Validator.isString(className);
		this.class = className;
		return this;
	}
	
	/**
	 * Name Getter
	 *
	 * @return {String}
	 */
	getName() {
		return this.name;
	}
	
	/**
	 * Name Setter
	 *
	 * @param {String} name
	 *
	 * @return {PreviewType}
	 */
	setName(name) {
		StyleEdit.Validator.isString(name);
		this.name = name;
		return this;
	}
	
	/**
	 * Preview CSS Getter
	 *
	 * @return {Object}
	 */
	getPreviewCss() {
		return this.previewCss;
	}
	
	/**
	 * Preview CSS Setter
	 *
	 * @param {Object} previewCss
	 *
	 * @return {PreviewType}
	 */
	setPreviewCss(previewCss) {
		StyleEdit.Validator.isObject(previewCss);
		this.previewCss = previewCss;
		return this;
	}
	
	/**
	 * Font-awesome Icon Class Getter
	 *
	 * @return {String}
	 */
	getIconClass() {
		return this.iconClass;
	}
	
	/**
	 * Font-awesome Icon Class Setter
	 *
	 * @param {String} iconClass
	 *
	 * @return {PreviewType}
	 */
	setIconClass(iconClass) {
		StyleEdit.Validator.isString(iconClass);
		this.iconClass = iconClass;
		return this;
	}
	
	/**
	 * Resolution Getter
	 *
	 * @return {String}
	 */
	getResolution() {
		return this.resolution;
	}
	
	/**
	 * Resolution Setter
	 *
	 * @param {String} resolution
	 *
	 * @return {PreviewType}
	 */
	setResolution(resolution) {
		StyleEdit.Validator.isString(resolution);
		this.resolution = resolution;
		return this;
	}
}
